<?php
$stop = false;

$db->query('SELECT 1');

set_time_limit(1800);
/*
$ionCubeVersion = (int) ioncube_loader_iversion();
if ($ionCubeVersion < 120000) {
	$softwareUpdate->show('This version of FileRun requires the "ionCube loader" PHP extension version 12.0.0 or newer: https://docs.filerun.com/ioncube'."\n");
	$softwareUpdate->show('The current "ionCube loader" version is '.$ionCubeVersion."\n\n");
	$softwareUpdate->show('If you plan to continue to use PHP 7.4, you will need to update this PHP extension to the latest version before continuing with the update.'."\n");
	$softwareUpdate->show('If you plan to switch to PHP 8.1 (recommended), you can proceed with the guide bellow. Do not forget to install ionCube after upgrading PHP.'."\n\n");
}
*/

$fileRunFiles = [
   'api.php',
   'dav.php',
   'guest.php',
   'index.php',
   'initial_version.txt',
   'LICENSE.txt',
   'recommended.htaccess',
   'recommended.web.config',
   'remote.php',
   'status.php',
   'sw.js',
   't.php',
   'a',
   'cron',
   'css',
   'customizables',
   'images',
   'js',
   'logout',
   'oauth2',
   'ocs',
   'oembed',
   'panel',
   'sso',
   'system',
   'wl'
];


/* ------------- Check permissions --------------------- */
$db->query('SELECT 1');
if (!$stop) {
	$softwareUpdate->show("Checking files permissions...");
	$stop = $softwareUpdate->checkFilePermissions($fileRunFiles);
	if ($stop !== false) {
		$softwareUpdate->show("all good.\r\n");
	}
}

$folderName = '_old_20220519';
$backupFolder = gluePath($config['path']['root'], '/', $folderName);

if (!is_dir($backupFolder)) {
	if (!mkdir($backupFolder)) {
		$softwareUpdate->show('Failed to create folder '.$backupFolder);
		$stop = true;
	}
}

$softwareUpdate->show("\n".'Tip: Keep this browser tab open or copy the following instructions to a text file.'."\n\n");

$step = 0;

$step++;
$softwareUpdate->show('#'.$step." Update PHP to version 8.1 
\t For Docker installs, simply swap the container's image to \"filerun/filerun:8.1\".
\t Important: Not 8.0 nor 8.2, unless ionCube has released an extension compatible with that PHP version.
\t Make sure the latest ionCube extension is installed (https://docs.filerun.com/ioncube)\n\n");

$step++;
$softwareUpdate->show("#".$step." Move all the FileRun application files from the existing installation folder \"".$config['path']['root']."\" to the \"".$folderName."\" subfolder. 
Here is the list of files which need to be moved:\n\n");

$command = "\t mv -t ".escapeshellarg($backupFolder.'/')."";
foreach ($fileRunFiles as $fileRunFile) {
	$fullFilePath = $config['path']['root'].'/'.$fileRunFile;
	if (file_exists($fullFilePath)) {
		$command .= ' '.escapeshellarg($fullFilePath);
		$softwareUpdate->show("\t".$fullFilePath."\n");
	}
}

$softwareUpdate->show("\n\n\t Command line example: \n\n".$command);


$step++;
$newFilesPath = $backupFolder.'/system/data/temp/_unzipped_update/files/';
$softwareUpdate->show("\n\n".'#'.$step.' Move all files and folders from "'.$newFilesPath.'" to "'.$config['path']['root'].'/"');

$command = "\t mv ".escapeshellarg($newFilesPath)."* ".escapeshellarg($config['path']['root'].'/');
$softwareUpdate->show("\n\n\t Command line example: \n\n".$command);

/*
$step++;
$softwareUpdate->show("\n\n".'#'.$step.' Rename the folder "'.$config['path']['root'].'/system/data" to "_data"');

$command = "\t mv ".escapeshellarg($config['path']['root'].'/system/data')." ".escapeshellarg($config['path']['root'].'/system/_data')."";
$softwareUpdate->show("\n\n\t Command line example: \n\n".$command);

$step++;
$softwareUpdate->show("\n\n".'#'.$step.' Move the folder "'.$backupFolder.'/system/data" inside "'.$config['path']['root'].'/system/'.'"');

$command = "\t mv ".escapeshellarg($backupFolder.'/system/data')." ".escapeshellarg($config['path']['root'].'/system/')."";
$softwareUpdate->show("\n\n\t Command line example: \n\n".$command);
*/

$step++;
$softwareUpdate->show("\n\n#".$step." Copy the following items:

".$backupFolder."/system/data/avatars/*
".$backupFolder."/system/data/.filerun.bin
".$backupFolder."/system/data/autoconfig.php

inside

\"".$config['path']['root']."/data\" (replace the ones at destination)");
$commands = "\t cp -fp ".escapeshellarg($backupFolder.'/system/data/avatars/')."* ".escapeshellarg($config['path']['root'].'/system/data/avatars/')."\n";
$commands .= "\t cp -fp ".escapeshellarg($backupFolder.'/system/data/.filerun.bin')." ".escapeshellarg($config['path']['root'].'/system/data/')."\n";
$commands .= "\t cp -fp ".escapeshellarg($backupFolder.'/system/autoconfig.php')." ".escapeshellarg($config['path']['root'].'/system/data')."\n";
$softwareUpdate->show("\n\n\t Command line examples: \n\n".$commands);

$step++;
$softwareUpdate->show("\n\n#".$step." Open FileRun (".$config['url']['root'].") in your browser to continue.

You will be presented with the FileRun installation wizard.
Simply go through it without making any change to the default settings.
Your existing data and settings will be preserved.

--- That's it. Ignore any text past this line. ---
");