<?php
namespace FileRun;
use FileRun\Files\Actions\WebLink;
Lang::setSection("Web Links");

$relativePath = \S::fromHTML($_REQUEST['path']);
$data = WebLink\Update::prepare($relativePath);
if (!$data) {
	jsonFeedback(false, WebLink\Update::getError());
}

$recordData = [];
if (isset($_POST['password'])) {
	$recordData['password'] = \S::fromHTML($_POST['password']);
}
if (isset($_POST['expiry'])) {
	$recordData['expiry'] = Utils\Date::HTMLDate2MySQL(\S::fromHTML($_POST['expiry']), true, "/", ["y" => 2, "m" => 0, "d" => 1]);
}
if (isset($_POST['download_limit']) && $_POST['download_limit'] > 0) {
	$recordData['download_limit'] = (int) \S::fromHTML($_POST['download_limit']);
} else {
	$recordData['download_limit'] = NULL;
}
$recordData['allow_uploads'] = \S::fromHTML($_POST['allow_uploads']) ? 1:0;
$recordData['allow_editing'] = \S::fromHTML($_POST['allow_editing']) ? 1:0;
$recordData['allow_downloads'] = \S::fromHTML($_POST['allow_downloads']) ? 1:0;
$recordData['show_comments'] = \S::fromHTML($_POST['show_comments']) ? 1:0;
$recordData['show_comments_names'] = \S::fromHTML($_POST['show_comments_names']) ? 1:0;
$recordData['show_metadata'] = \S::fromHTML($_POST['show_metadata']) ? 1:0;
$recordData['require_login'] = \S::fromHTML($_POST['require_login']) ? 1:0;
$recordData['notify'] = \S::fromHTML($_POST['notify']) ? 1:0;
$recordData['download_terms'] = \S::fromHTML($_POST['download_terms']);

$rs = WebLink\Update::run($data, $recordData);
if (!$rs) {
	jsonFeedback(false, WebLink\Update::getError());
}

jsonFeedback(true, 'Web link successfully updated!');
