<?php
namespace FileRun;
\FileRun\Perms::checkAndExit("weblink");
Lang::setSection("Web Links");

$linkId = \S::fromHTML($_REQUEST['linkId']);
$linkInfo = WebLinks::get($linkId);
if (!$linkInfo) {
	jsonOutput(['success' => false, 'error' => Lang::t('Invalid link ID!')]);
}
if ($linkInfo['uid'] != $auth->currentUserInfo['id']) {
	jsonOutput(['success' => false, 'error' => Lang::t('Invalid link!')]);
}

if (!$linkInfo['short_url']) {
	if ($_POST['url']) {
		$longURL = \S::fromHTML($_POST['url']);
	} else {
		$longURL = WebLinks::getURL(["id_rnd" => $linkInfo['id_rnd']]);
	}

	$isBitly = false;
	if (isset($config['app']['weblinks']['custom_url_shortener'])) {
		$fetchOptions = [
			'url' => $config['app']['weblinks']['custom_url_shortener']
		];
		if (strpos($fetchOptions['url'], '###') !== false) {
			$fetchOptions['url'] = str_replace('###', urlencode($longURL), $fetchOptions['url']);
		} else {
			$fetchOptions['postVars'] = [
				'url' => $longURL,
				'URL' => $longURL,
				'format' => 'simple'
			];
		}
	} else {
		if (!$settings->bitly_access_token) {
			jsonOutput(['success' => false, 'error' => Lang::t('A Bitly Access Token needs to be configured from the control panel.')]);
		}
		$fetchOptions = [
			'url' => 'https://api-ssl.bitly.com/v4/shorten',
			'headers' => ['Authorization' => 'Bearer '.$settings->bitly_access_token],
			'method' => 'POST',
			'json' => ['long_url' => $longURL]
		];
		$isBitly = true;
	}
	$output = Utils\HTTP::fetchFromURL($fetchOptions);

	$successfull = false;
	if (!$output) {
		$shortURL = 'Error: '.Utils\HTTP::getError();
	} else {
		if ($isBitly) {
			$response = json_decode($output, true);
			if ($response['link']) {
				$successfull = true;
				$shortURL = $response['link'];
			} else {
				$shortURL = 'Error: ' . $output;
			}
		} else {
			if (substr($output, 0, 4) == 'http') {
				$successfull = true;
				$shortURL = $output;
			} else {
				$shortURL = 'Error: ' . $output;
			}
		}
		if ($successfull) {
			WebLinks::update(["short_url" => $shortURL], $linkInfo['id']);
		}
	}
} else {
	$shortURL = $linkInfo['short_url'];
}

jsonOutput([
	'success' => true,
	'url' => $shortURL
]);