<?php
namespace FileRun;
use FileRun\Files\Actions\Metadata;
Lang::setSection("Metadata");

if (!AuthSessions::hasValidCSRFToken()) {
	jsonFeedback(false, 'Please reload the browser and try again.');
}

$paths = $_POST['paths'];
if (!is_array($paths)) {
	jsonFeedback(false, 'Invalid request, missing list of files!');
}
if (!count($paths)) {
	jsonFeedback(false, 'No items specified!');
}

if (empty($_POST['text'])) {
	jsonFeedback(false, 'Invalid request, missing tag!');
}
$text = trim($_POST['text']);
if (!$text) {
	jsonFeedback(false, 'Invalid request, missing tag!');
}
$newColor = \S::R('newColor');

$items = Metadata\Prepare::prepareWriteMultiple($paths);
if (!$items) {
	jsonFeedback(false, Metadata\Prepare::getError());
}

$count = 0;
$updates = [];

$newColor = Utils\Color\Named::adjust($newColor);

$newColor ??= Tags::getTagColor($text);

$newTag = ['text' => $text, 'color' => $newColor];

$newTagGlued = Tags::glue($newTag);
$messages = [];
foreach ($items as $itemInfo) {
	$existingTags = Tags::getValuesByMetaFileId([
		'fileId' => $itemInfo['metaFileInfo']['id'],
		'returnId' => true
	]);
	$found = false;
	foreach ($existingTags as $existing) {
		if (mb_strtolower($existing['text']) == mb_strtolower($text)) {
			if ($newColor != $existing['color']) {
				$found = true;
				break;
			}
		}
	}
	if (!$found) {
		continue;
	}
	$rs = Tags::updateById($newTagGlued, $existing['id']);
	if (!$rs) {
		continue;
	}

	$count++;
	$updates[] = [
		'path' => $itemInfo['relativePath'],
		'updates' => [
			'tags' => [
				'removed' => [$existing],
				'added' => [$newTag]
			]
		]
	];

	Metadata\Tags\Consequences::onTagChanged($itemInfo, $existing, $newTag);
}



if ($count == 1) {
	$messages[] = Lang::t('One item was changed');
} else if ($count > 1) {
	$messages[] = Lang::t('%1 items were changed', false, [$count]);
} else {
	$messages[] = Lang::t('No changes were made');
}

jsonOutput([
	'success' => ($count > 0),
	'msg' => $messages,
	'updates' => $updates,
	'newColor' => $newColor
]);