<?php
namespace FileRun\Utils;
use FileRun\Files\FM;

class Update {
	var $errorMsg = false;
	var $log;
	var $updatedRoot;

	function __construct() {
		global $config;
		$this->log = "";
		$this->updatedRoot = gluePath($config['path']['temp'], "_unzipped_update/files");
	}

	function newFolder($relativePath) {
		global $config;
		$currentPath = gluePath($config['path']['root'], "/", $relativePath);
		$updatedPath = gluePath($this->updatedRoot, "/", $relativePath);
		if (is_dir($currentPath)) {
			$rs = FM\Delete::deleteDir($currentPath);
			if (!$rs) {
				$this->errorMsg = "Failed to delete current folder (".$currentPath."): ". FM\Delete::$errMsg;
				return false;
			}
		}
		$rs = FM\Copy::copyDir($updatedPath, $currentPath);
		if (!$rs) {
			$this->errorMsg = "Failed to copy update folder (\"".$updatedPath."\" to \"".$currentPath."\"): ". FM\Copy::$errMsg;
			return false;
		}
		return true;
	}

	function show($str) {
		$this->log .= $str;
		echo $str;
		flush();
	}

	function replaceUpdatedFile($relativePath) {
		global $config;
		$this->show("Updating \"".$relativePath."\" ......");
		$currentPath = gluePath($config['path']['root'], "/", $relativePath);
		$updatedPath = gluePath($this->updatedRoot, "/", $relativePath);
		if (file_exists($currentPath)) {
			$rs = unlink($currentPath);
			if (!$rs) {
				return true;
			}
		}
		$rs = FM\Copy::copyFile($updatedPath, $currentPath);
		if (!$rs) {
			$this->show(FM\Copy::$errMsg);
			return true;
		} else {
			$this->show("Ok.\r\n");
		}
	}

	function removeItems($relativePath) {
		global $config;
		$this->show("Removing \"".$relativePath."\" ......");
		$currentPath = gluePath($config['path']['root'], "/", $relativePath);
		if (file_exists($currentPath)) {
			$rs = FM\Delete::delete($currentPath);
		} else {
			$rs = true;
		}
		if (!$rs) {
			$this->show(FM\Delete::$errMsg);
			return true;
		} else {
			$this->show("Ok.\r\n");
		}
	}

	function addNewFolder($relativePath) {
		$this->show("Updating folder \"".$relativePath."\" ......");
		$rs = $this->newFolder($relativePath);
		if (!$rs) {
			$this->show($this->errorMsg);
			return true;
		} else {
			$this->show("Ok.\r\n");
		}
	}

	function checkFilePermissions($list) {
		global $config;
		foreach ($list as $relativePath) {
			$currentPath = gluePath($config['path']['root'], "/", $relativePath);
			if (file_exists($currentPath)) {
				if (!is_writable($currentPath)) {
					$this->show("\"".$currentPath."\" is not writable. Fix the problem and try again.\r\n");
					return false;
				}
			}
		}
	}

	function backupFiles($list, $updateVersion) {
		global $config;
		foreach ($list as $relativePath) {
			$this->show("Backing up \"".$relativePath."\" ......");
			$currentPath = gluePath($config['path']['root'], "/", $relativePath);
			$target = gluePath($config['path']['temp'], '/', 'backup_'.$updateVersion, '/', $relativePath);
			if (!file_exists($currentPath)) {
				$this->show("Missing.\r\n");
			} else {
				$isFile = is_file($currentPath);
				if ($isFile) {
					$targetdirname = \FM::dirname($target);
					if (!is_dir($targetdirname)) {
						FM\Create::createPath($targetdirname);
					}
				}
				$rs = FM\Copy::copy($currentPath, $target);
				if (!$rs) {
					$this->show(FM\Copy::$errMsg);
					return true;
				} else {
					$this->show("Ok.\r\n");
				}
			}
		}
	}
}