<?php
namespace FileRun\Files\Actions\WebLink;
use FileRun\Files\Actions\Base;
use FileRun\Log;
use FileRun\Perms;
use FileRun\WebLinks;

class Update extends Base {
	static function prepareByIdRnd($id_rnd) {
		$relativePath = Prepare::getRelativePathByToken($id_rnd);
		if (!$relativePath) {
			self::$error = Prepare::$error;
			return false;
		}
		return self::prepare($relativePath);
	}

	static function prepare($relativePath) {
		$data = Prepare::prepare($relativePath);
		if (!$data) {
			self::$error = Prepare::$error;
			return false;
		}
		if ($data['collection']) {
			$data['linkInfo'] = WebLinks::getByCollectionId($data['collectionInfo']['id']);
		} else {
			$data['linkInfo'] = WebLinks::getByPath($data['fullPath']);
		}
		if (!$data['linkInfo']) {
			self::$error = ['public' => 'The web link no longer exists!'];
			return false;
		}
		global $auth;
		if ($data['linkInfo']['uid'] != $auth->currentUserInfo['id']) {
			self::$error = ['public' => 'The specified web link does not belong to the current user!'];
			return false;
		}
		return $data;
	}

	static function run(array $data, array $updated) {
		global $config;
		if (count($updated) == 0) {
			self::$error = [
				'code' => 'no-changes',
				'public' => 'No changes to make'
			];
			return false;
		}
		if (isset($config['app']['weblinks']['forcePasswords'])) {
			if (
				(!isset($updated['password']) && !$data['linkInfo']['password']) ||
				(isset($updated['password']) && !$updated['password'])
			) {
				self::$error = ['public' => 'You are required to password protect the link'];
				return false;
			}
		}
		if (isset($updated['password']) && strlen($updated['password']) > 0) {
			//todo: if a password was set from before, and the password policy changed in the meantime, it should check the old password and prevent the update unless a newer pass is set?
			if (!Perms::isSuperUser()) {
				$pp = new \FileRun\PassPolicy($updated['password']);
				if (!$pp->validate()) {
					self::$error = ['public' => $pp->errors[0]];
					return false;
				}
			}
		}
		if ($updated['allow_uploads']) {
			if (!Perms::getOne('upload')) {
				self::$error = ['public' => 'You cannot grant the permission of uploading files!'];
				return false;
			}
			if ($data['shareInfo'] && !$data['shareInfo']['perms_upload']) {
				self::$error = ['public' => 'You cannot allow uploads in this folder!'];
				return false;
			}
		}
		if ($updated['allow_editing']) {
			if (Perms::getOne('readonly')) {
				self::$error = ['public' => 'You cannot grant the permission of editing files!'];
				return false;
			}
			if ($data['shareInfo'] && !$data['shareInfo']['perms_alter']) {
				self::$error = ['public' => 'You cannot allow editing in this folder!'];
				return false;
			}
		}
		if (isset($updated['download_terms'])) {
			$updated['download_terms'] = trim($updated['download_terms']);
			if (!$updated['download_terms']) {
			    $updated['download_terms'] = NULL;
			}
		}
		//asdf($updated, $data['linkInfo'], array_diff_assoc($updated, $data['linkInfo']));
		$update = array_diff_assoc($updated, $data['linkInfo']);

		if (!$update) {
			self::$error = [
				'code' => 'no-changes',
				'public' => 'No changes were made!'
			];
			return false;
		}
		$update['date_modified'] = 'NOW()';
		$rs = WebLinks::update($update, $data['linkInfo']['id']);
		if (!$rs) {
			self::$error = ['public' => 'Failed to update web link!'];
			return false;
		}
		$loggedData = [
			'full_path' => $data['fullPath'],
			'relative_path' => $data['relativePath'],
			'details' => $data['linkInfo']
		];
		if (isset($data['logging']['details']) && is_array($data['logging']['details'])) {
			$loggedData = array_merge($loggedData, $data['logging']['details']);
		}
		Log::add(false, 'weblink_update', $loggedData);
		return true;
	}
}