<?php
use FileRun\Files\Plugin;

class custom_zoho extends Plugin {

	public bool $weblinksCompatible = true;
	public $online = true;
	static $localeSection = "Custom Actions: Zoho";
	static $publicMethods = ['thumb', 'saveRemoteChanges'];

	var array $writerExtensions = ["doc", "docx", "html", "rtf", "txt", "odt", "sxw"];
	var array $sheetExtensions = ["xls", "xlsx", "sxc", "csv", "ods", "tsv"];
	var array $showExtensions = ["ppt", "pptx", "pps", "odp", "sxi", "ppsx"];

	function init() {
		$this->settings = [
			[
				'key' => 'APIKey',
				'title' => self::t('API key'),
				'comment' => self::t('Get it from %1', ['<a href="https://www.zoho.com/officeplatform/" target="_blank">zoho.com/officeplatform/</a>'])
			],
			[
				'key' => 'api_hostname',
				'title' => self::t('Zoho API domain'),
				'comment' => self::t('Either <b>zoho.com</b> or <b>zoho.eu</b>')
			],
			[
				'key' => 'allow_without_download',
				'title' => self::t('Allow previewing without download permission'),
				'type' => 'checkbox',
				'helpText' => self::t('Use this option only if your documents are not confidential.')
			]
		];
		$this->JSconfig = [
			"title" => self::t("Zoho Editor"),
			'icon' => 'images/icons/zoho.png',
			"extensions" => [
				...$this->writerExtensions,
				...$this->sheetExtensions,
				...$this->showExtensions
			],
			"popup" => true,
			"requires" => ["preview"],
			"requiredUserPerms" => ["preview"],
			"createNew" => [
				"title" => self::t("Document with Zoho"),
				"options" => [
					[
						"fileName" => self::t("New Document.odt"),
						"title" => self::t("Word Document"),
						"icon" => 'images/icons/zwriter.png'
					],
					[
						"fileName" => self::t("New Spreadsheet.ods"),
						"title" => self::t("Spreadsheet"),
						"icon" => 'images/icons/zsheet.png'
					],
					[
						"fileName" => self::t("New Presentation.odp"),
						"title" => self::t("Presentation"),
						"icon" => 'images/icons/zshow.png'
					]
				]
			]
		];
	}

	function isDisabled() {
		return ($this->getSetting('APIKey') == '');
	}

	function run() {
		require $this->path."/display.php";
	}

	function createBlankFile() {
		$fileName = \S::fromHTML($_POST['fileName']);
		$this->data['relativePath'] = gluePath($this->data['relativePath'], $fileName);
		$this->writeFile([
			'preventOverwrite' => true,
			'source' => 'string',
			'contents' => ''
		]);
		jsonFeedback(true, 'Blank file created successfully');
	}

	function saveRemoteChanges() {
		$uploadTempPath = $_FILES['content']['tmp_name'];
		if (!$uploadTempPath) {
			self::outputError('Missing upload file', 'text');
		}
		$this->writeFile([
			'source' => 'move',
			'moveFullPath' => $uploadTempPath
		]);
		echo 'File successfully saved';
	}
}