<?php

use FileRun\Files\Plugin;

class custom_video_player extends Plugin {

	public bool $weblinksCompatible = true;
	static $localeSection = 'Custom Actions: Video Player';
	static $publicMethods = ['openInBrowser', 'stream', 'thumb'];

	function init() {
		$this->JSconfig = [
			'title' => self::t('Video Player'),
			'iconCls' => 'fa-play-circle-o',
			'useWith' => ['wvideo'],
			'popup' => true,
			'requires' => ['download']
		];
		$this->settings = [
			[
				'key' => 'allow_without_download',
				'title' => self::t('Allow playback without download permission'),
				'type' => 'checkbox',
				'helpText' => self::t('Use this option only if your files are not confidential.')
			],
			[
				'key' => 'loop_playback',
				'title' => self::t('Loop playback'),
				'type' => 'checkbox'
			]
		];
	}

	function run() {
		require $this->path.'/display.php';
		return true;
	}

	function stream() {
		$this->streamFileForPreview();
	}
}