<?php
use FileRun\Files\Actions\WebLink;
use FileRun\Files\Plugin;
use FileRun\Thumbs\Utils;
use FileRun\WebLinks;

class custom_tinymce_filepicker extends Plugin {

	static $localeSection = 'Custom Actions';

	function init() {
		$this->JSconfig = [
			"title" => self::t('File Picker for TinyMCE'),
			'icon' => 'images/icons/tinymce.png',
			'popup' => true,
			'useWith' => ['nothing'],
			"requires" => ['download', 'weblink']
		];
	}

	function run() {
		$data = WebLink\Prepare::prepare($this->data['relativePath']);
		if (!$data) {
			self::outputError(WebLink\Prepare::getError());
		}
		$linkInfo = WebLinks::getByPath($data['fullPath']);

		if (!$linkInfo) {
			$linkInfo = WebLink\Create::createDefault($data);
			if (!$linkInfo) {
				self::outputError(WebLink\Create::getError());
			}
		}

		$linkInfo['url'] = WebLinks::getURL(['id_rnd' => $linkInfo['id_rnd']]);

		$fileName = $data['alias'] ?? \FM::basename($data['fullPath']);
		$ext = \FM::getExtension($fileName);
		if (Utils::isWebSafe($ext)) {
			$imageURL =  WebLinks::getURL([
				'id_rnd' => $linkInfo['id_rnd'],
				'fmode' => 'open'
			]);
			$html = '<img src="'.$imageURL.'" />';
		} else {
			$html = $fileName;
		}
		$html = '<a href="'.$linkInfo['url'].'">'.$html.'</a>';
		?>
		<script>
			if (!window.parent) {
				document.write('This plugin is designed to be used from within a TinyMCE editor!');
			} else {
				with (window.parent) {
					window.parent.postMessage({
						sender: 'FileRun',
						html: '<?php echo \S::safeJS($html);?>'
					}, '*');
				}
			}
		</script>
	<?php
	}
}