<?php

use FileRun\Files\Plugin;
use FileRun\Utils\HTTP;

class custom_onlyoffice extends Plugin {

	public bool $weblinksCompatible = true;
	public $online = true;
	static $localeSection = 'Custom Actions: ONLYOFFICE';
	static $publicMethods = ['thumb', 'saveRemoteChanges'];

	var $canEditTypes = [
		'doc', 'docx', 'dotx', 'odt', 'ott', 'rtf', 'txt', 'html',
		'xls', 'xlsx', 'xltx', 'ods', 'ots', 'csv',
		'ppt', 'pptx', 'potx', 'odp', 'otp', 'pdf'
	];

	var $ext = [
		'text' => ['doc', 'docx', 'dot', 'dotx', 'dotm', 'odt', 'fodt', 'ott', 'rtf', 'txt', 'pdf', 'html', 'epub', 'xps', 'oxps', 'djvu', 'oform', 'fb2'],
		'spreadsheet' => ['xls', 'xlsx', 'xlsm', 'xlsb', 'xltx', 'xltm', 'ods', 'fods', 'ots', 'csv'],
		'presentation' => ['ppt', 'pptx', 'pps', 'ppsx', 'ppsm', 'pot', 'potx', 'potm', 'odp', 'otp', 'fodp'],
	];

	function init() {
		$this->settings = [
			[
				'key' => 'serverURL',
				'title' => self::t('DocumentServer URL'),
				'comment' => self::t('Download and install %1', ['<a href="https://github.com/ONLYOFFICE/DocumentServer" target="_blank">ONLYOFFICE DocumentServer</a>'])
			],
			[
                'key' => 'serverSecret',
                'title' => self::t('JWT secret')
            ],
			[
				'key' => 'allow_without_download',
				'title' => self::t('Allow previewing via web links without download permission.'),
				'type' => 'checkbox',
				'helpText' => self::t('Use this option only if your documents are not confidential.')
			],
			[
				'key' => 'oo_autosave',
				'title' => self::t('Enable autosave'),
				'type' => 'checkbox',
				'defaultValue' => '0'
			],
			[
				'key' => 'oo_chat',
				'title' => self::t('Enable chat'),
				'type' => 'checkbox',
				'defaultValue' => '0'
			],
			[
				'key' => 'oo_comments',
				'title' => self::t('Enable comments'),
				'type' => 'checkbox',
				'defaultValue' => '0'
			],
			[
				'key' => 'oo_compactHeader',
				'title' => self::t('Compact header'),
				'type' => 'checkbox',
				'defaultValue' => '1'
			],
			[
				'key' => 'oo_zoom',
				'title' => self::t('Zoom'),
				'width' => 50,
				'defaultValue' => '-2'
			]
		];
		$this->JSconfig = [
			"title" => self::t("ONLYOFFICE"),
			"popup" => true,
			'icon' => 'images/icons/onlyoffice.svg',
			"loadingMsg" => self::t('Loading document in ONLYOFFICE. Please wait...'),
			'extensions' => [
				...$this->ext['text'],
				...$this->ext['spreadsheet'],
				...$this->ext['presentation']
			],
			"requires" => ["download"],
			"requiredUserPerms" => ["download"],
			"createNew" => [
				"title" => self::t("Document with ONLYOFFICE"),
				"options" => [
					[
						"fileName" => self::t("New Document.docx"),
						"title" => self::t("Word Document"),
						"iconCls" => 'fa-file-word-o'
					],
					[
						"fileName" => self::t("New Spreadsheet.xlsx"),
						"title" => self::t("Spreadsheet"),
						"iconCls" => 'fa-file-excel-o'
					],
					[
						"fileName" => self::t("New Presentation.pptx"),
						"title" =>  self::t("Presentation"),
						"iconCls" => 'fa-file-powerpoint-o'
					]
				]
			]
		];
	}

	function isDisabled() {
		return ($this->getSetting('serverURL') == '');
	}

	function run() {
		require $this->path."/run.php";
	}

	function saveRemoteChanges() {
		$rs = @file_get_contents("php://input");
		if ($rs === false) {
			self::outputError(error_get_last()['message'], 'text');
		}
		if (!$rs) {
			self::outputError('Empty contents.', 'text');
		}
		$rs = json_decode($rs, true);
		if ($rs["status"] != 2 && $rs["status"] != 6) {
			echo json_encode(['error' => 0]);
			return false;
		}
		if (!$rs["url"]) {
			self::outputError('No download URL provided.', 'text');
		}
		$contents = HTTP::fetchFromURL(['url' => $rs["url"]]);
		if ($contents === false) {
			self::outputError(error_get_last()['message'], 'text');
		}
		if (!$contents) {
			self::outputError('Empty contents.', 'text');
		}
		$this->writeFile([
			'source' => 'string',
			'contents' => $contents
		]);
		echo json_encode(['error' => 0]);
	}

	function createBlankFile() {
		$fileName = \S::fromHTML($_POST['fileName']);
		$this->data['relativePath'] = gluePath($this->data['relativePath'], $fileName);
		$ext = \FM::getExtension($fileName);
		if (!in_array($ext, $this->canEditTypes)) {
			jsonOutput([
				"rs" => false,
				"msg" => self::t('The file extension needs to be one of the following: %1', [implode(', ', $this->canEditTypes)])
			]);
		}
		$sourceFullPath = gluePath($this->path, 'blanks/blank.'.$ext);
		$this->writeFile([
			'preventOverwrite' => true,
			'source' => 'copy',
			'sourceFullPath' => $sourceFullPath
		]);
		jsonFeedback(true, 'Blank file created successfully');
	}
}