<?php
namespace FileRun;

global $config;
if (!$config) {exit();}

if ($this->isLimitedPreview()) {
	$this->centeredThumb();
	return;
}

$this->data['contents'] = $this->readFile(['errorHandling' => 'html']);
$enc = mb_list_encodings();
if ($_REQUEST['charset'] && in_array($_REQUEST['charset'], $enc)) {
	$this->data['contents'] = \S::convert2UTF8($this->data['contents'], $_REQUEST['charset']);
}

$page = [
	'styles' => [
		'basic',
		'markdown'
	],
	'loadMsg' => false,
	'contents' => '<div class="markdown-body">'.Utils\Markup\Markdown::toHTML($this->data['contents']).'</div>'
];

header("X-Content-Type-Options: nosniff");
require $config['path']['includes'].'/ui/page/plugin.php';