<?php

use FileRun\Files\Plugin;

class custom_kml_viewer extends Plugin {

	public bool $weblinksCompatible = true;
	public $online = true;
	static $localeSection = 'Custom Actions: Google Maps';

	function init() {
		$this->settings = [
			[
				'key' => 'APIKey',
				'title' => self::t('Google Maps JavaScript API Key'),
				'comment' => \FileRun\Lang::t('Get it from %1', 'Admin', ['<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">Google Maps APIs</a>'])
			]
		];
		$this->JSconfig = [
			"title" => self::t('Google Maps'),
			'icon' => 'images/icons/gmaps.svg',
			"extensions" => ["kml", "kmz", "xml"],
			"popup" => true,
			"requiredUserPerms" => ["download"],
			"requires" => ["download"]
		];
	}

	function isDisabled() {
		return (strlen(self::getSetting('APIKey')) == 0);
	}

	function run() {
		require $this->path."/display.php";
	}
}