<?php
namespace FileRun;
global $config;
if (!$config) {exit();}

$ext = \FM::getExtension($this->data['fileName']);
$showThumb = !Thumbs\Utils::isWebSafe($ext);

if ($this->data['weblink']) {
	if ($showThumb || !$this->data['weblink']['linkInfo']['allow_downloads']) {
		$url = $this->data['weblink']['base_url'].'&method=thumb';
	} else {
		$url = $this->data['weblink']['download_url'];
	}
} else {
	if ($showThumb) {
		$url = $this->actionURL.'&method=thumb&path='.\S::forURL($this->data['relativePath']);
	} else {
		$url = $config['url']['root'] . '/?module=custom_actions&action=open_in_browser&path='.\S::forURL($this->data['relativePath']);
	}
}
if ($this->data['version']) {
	$url .= '&version='.\S::forURL($this->data['version']);
}

$page = [
	'loadMsg' => false,
	'manualEnd' => true
];
require $config['path']['includes'].'/ui/page/plugin.php';
?>
<style>
	body {
		border: 0;  margin: 0;  padding: 0;  overflow:hidden;
	}
	img {
		max-height: 90%;
		max-width: 90%;
		position: absolute;
		top: 50%;
		left: 50%;
		transform: translate(-50%, -50%);
		<?php if ($this->data['weblink'] && !$this->data['weblink']['linkInfo']['allow_downloads']) { ?>
        pointer-events: none;
		<?php } ?>
	}
</style>
<img src="<?php echo $url;?>" />
</body>
</html>