<?php
namespace FileRun;

use FileRun\Files\Actions\Upload\Utils;
use FileRun\Thumbs;

global $settings, $config;
if (!$config) {exit();}

$typeInfo = \FM::fileTypeInfo($this->data['fileName']);
if ($typeInfo['type'] == 'img') {
	$url = $this->actionURL.'&method=openInBrowser&noCache='.time();
} else {
	if (!Thumbs\Utils::extCanHaveThumb($typeInfo['extension'])) {
		exit('Cannot convert file type to image.');
	}
	$url = $config['url']['root'].'/t.php?width=4000&height=4000&p='.\S::forURL($this->data['relativePath']).'&noCache='.time();
}
if ($this->data['version']) {
	$url .= '&version='.\S::forURL($this->data['version']);
}

$chunkSize = Utils::getUploadChunkSize();

$originalExt = \FM::getExtension($this->data['fileName'], true);

if (in_array($typeInfo['extension'], ['png', 'svg', 'gif', 'bmp'])) {
	$saveExtension = $typeInfo['extension'] == 'png' ? $originalExt : 'png';
	$saveMimeType = 'image/png';
} else {
	$saveExtension = in_array($typeInfo['extension'], ['jpeg', 'jpg']) ? $originalExt : 'jpg';
	$saveMimeType = 'image/jpeg';
}

if ($this->data['relativePathInfo']['type'] == 'shared') {
	if (!$this->data['relativePathInfo']['relative_path']) {
		$folderPath = \FM::dirname($this->data['relativePath']);
	}
	$saveFileName = \FM::basename($this->data['relativePath']);
} else {
	$folderPath = \FM::dirname($this->data['relativePath']);
	$saveFileName = \FM::replaceExtension($this->data['fileName'], $saveExtension);
}

$vars = [
	'URLRoot' => $config['url']['root'],
	'originalFileName' => $this->data['fileName'],
	'saveFileName' => $saveFileName,
	'saveMimeType' => $saveMimeType,
	'folderPath' => $folderPath,
	'imageURL' => $url,
	//'saveURL' => $saveURL,
	'windowId' => $_REQUEST['_popup_id'],
	'UploadChunkSize' => $chunkSize,
	'csrf_token' => self::getCSRFToken(),
	'devMode' => $config['dev']['mode']
];

$page = [
	'styles' => [
		'basic', 'fa', 'ext',
		'cropper',
		$this->url.'/editor.css?v='.$settings->currentVersion
	],
	'scripts' => [
		'ext',
		'ext/components/slider',
	    'flowutils',
		'cropper',
		$this->url.'/app.js?v='.$settings->currentVersion,
		$this->url.'/caman.full.min.js?v='.$settings->currentVersion
	],
	'jsGlobals' => [
		'FR.vars' => $vars
	]
];

require $config['path']['includes'].'/ui/page/plugin.php';