var FR = {
	UI: {}, changesSaved: true,
	init: function() {
		Ext.get('loadMsg').fadeOut();
		Ext.QuickTips.init();
		Ext.getBody().mask('Loading image..');
		this.UI.tbar = new Ext.Toolbar({
			cls: 'fr-viewport-top-bar',
			items: [
				{
					text: Ext.isMobile ? false : "Save",
					iconCls: Ext.isMobile ? 'fa-save' : false,
					cls: 'fr-btn-primary',
					style: 'margin-right:10px',
					handler: function(){this.save(false);}, scope: this
				},
				{
					text: "Save and close",
					cls: 'fr-btn-primary',
					style: 'margin-right:10px',
					hidden: Ext.isMobile,
					handler: function(){this.save(true);}, scope: this
				},
				{
					text: "Close",
					style: 'margin-right:10px',
					hidden: !FR.vars.windowId,
					handler: function(){FR.tryToCloseWindow();}
				},
				{
					xtype: 'tbtext', id: 'status', text: ''
				},
				'->',
				{
					iconCls: 'fa-lg fa-check icon-green',
					hidden: true,
					style: 'margin-left:10px',
					id: 'apply',
					text: 'Apply',
					handler: function () {
						this.applyChanges();
					}, scope: this
				},
				{
					iconCls: 'fa-lg fa-times',
					hidden: true,
					style: 'margin-left:10px',
					id: 'cancel',
					text: 'Cancel',
					handler: function () {
						this.cancelChanges();
					}, scope: this
				},
				{
					iconCls: 'fa-lg fa-crop-alt',
					enableToggle: true,
					id: 'cropToggle',
					tooltip: 'Crop',
					style: 'margin-left:10px',
					toggleHandler: function (btn, pressed) {
						if (pressed) {
							this.editor.crop();
						} else {
							this.editor.clear();
						}
						Ext.getCmp('apply').setVisible(pressed);
						Ext.getCmp('cancel').setVisible(pressed);
						this.UI.tbar.doLayout(true);
					}, scope: this
				},
				{
					xtype: 'tbtext', id: 'resolution', text: ''
				},
				{
					iconCls: 'fa-lg fa-expand-alt',
					tooltip: 'Scale down',
					menuAlign: 't-b',
					menu: {
						items: [{
							xtype: 'slider',
							id: 'scaleSlider',
							width: 200,
							style: 'margin:10px',
							decimalPrecision: 2,
							value: 100,
							minValue: 1,
							maxValue: 100,
							listeners: {
								drag: function(s, v) {
									v = v/100;
									this.editor.scale(v, v);
									Ext.get('resolution').update(
										Math.round(this.currentImageData.naturalWidth*v)+
										' <i class="fa fa-times"></i> '+
										Math.round(this.currentImageData.naturalHeight*v)
									)
								},
								changecomplete: function() {
									Ext.getCmp('apply').setVisible(true);
									Ext.getCmp('cancel').setVisible(true);
									this.UI.tbar.doLayout(true);
								},
								scope: this
							}
						}],
						listeners: {
							show: function() {
								this.currentImageData = this.editor.getImageData();
								this.editor.zoomTo(1);
							}, scope: this
						}
					},
				},
				'-',
				{
					iconCls: 'fa-lg fa-redo',
					tooltip: 'Rotate',
					menu: [
						{
							iconCls: 'fa-undo',
							text: '90&deg;',
							handler: function () {
								this.editor.rotate(-90);
								return false;
							}, scope: this
						},
						{
							iconCls: 'fa-redo',
							text: '90&deg;',
							handler: function () {
								this.editor.rotate(90);
								return false;
							}, scope: this
						},
						{
							text: '1&deg;',
							handler: function() {return false;},
							menu: {
								items: [{
									xtype: 'slider',
									vertical: true,
									height: 200,
									style: 'margin:10px',
									value: 0,
									minValue: -90,
									maxValue: 90,
									listeners: {
										drag: function (s, newValue) {
											this.editor.rotateTo(newValue);
										},
										scope: this
									}
								}],
								listeners: {
									show: function(menu) {
										var slider = menu.items.items[0];
										var editorData = this.editor.getData();
										var currentRoateAngle = editorData.rotate;
										slider.setMinValue(currentRoateAngle-90);
										slider.setMaxValue(currentRoateAngle+90);
										slider.setValue(currentRoateAngle);
									}, scope: this
								}
							}
						},
						'-',
						{
							iconCls: 'fa-times',
							text: 'Reset',
							handler: function() {this.editor.rotateTo(0);}, scope: this
						}
					]
				},
				{
					iconCls: 'fa-lg fa-adjust',
					tooltip: 'Adjust',
					menu: [
						{
							text: 'Brightness',
							iconCls: 'fa-lg fa-sun',
							handler: () => this.imageControl('Brightness', 'brightness')
						},
						{
							text: 'Contrast',
							iconCls: 'fa-lg fa-adjust',
							handler: () => this.imageControl('Contrast', 'contrast')
						},
						{
							text: 'Saturation',
							iconCls: 'fa-lg fa-tint',
							handler: () => this.imageControl('Saturation', 'saturation')
						},
						{
							text: 'Sharpen',
							iconCls: 'fa-lg fa-eye',
							handler: () => this.imageControl('Sharpen', 'sharpen')
						}
					]
				},
				{
					iconCls: 'fa-lg fa-arrows-h',
					tooltip: 'Flip horizontal',
					handler: function () {
						this.editor.scaleX(-this.editor.getData().scaleX);
					}, scope: this
				},
				{
					iconCls: 'fa-lg fa-arrows-v',
					tooltip: 'Flip vertical',
					handler: function () {
						this.editor.scaleY(-this.editor.getData().scaleY);
					}, scope: this
				},
				'-',
				{
					iconCls: 'fa-lg fa-compress',
					tooltip: 'Fit to screen',
					handler: function () {
						this.editor.reset();
						var canvasData = this.editor.getCanvasData();
						Ext.get('zoomStatus').update(Math.round(canvasData.width/canvasData.naturalWidth*100)+'%');
					}, scope: this
				},
				{
					xtype: 'tbtext', id: 'zoomStatus', text: '', style: 'width:50px'
				},
				{
					iconCls: 'fa-lg fa-expand',
					tooltip: 'Full size',
					handler: function () {
						this.editor.zoomTo(1);
					}, scope: this
				},
				'-',
				{
					iconCls: 'fa-lg fa-refresh',
					tooltip: 'Reload image',
					handler: function () {
						this.editor.replace(FR.vars.imageURL);
					}, scope: this
				}
			]
		});
		new Ext.Viewport({
			layout: 'fit',
			items: {
				layout: 'fit',
				html: '<div id="editor" class="cropperEditor"></div>',
				tbar: this.UI.tbar
			},
			listeners: {
				'resize': function() {
					if (this.editor) {
						this.editor.resize.defer(200, this.editor);
						this.editor.reset.defer(300, this.editor);
					}
				},
				'afterrender': function() {
					this.status = Ext.getCmp('status');
					var image = Ext.DomHelper.append('editor', {tag: 'img', src: FR.vars.imageURL, class: 'cropperSource'});

					this.editor = new Cropper(image, {
						viewMode: 1,
						autoCrop: false,
						dragMode: 'move',
						highlight: false,
						toggleDragModeOnDblclick: false,
						ready: function() {
							Ext.getBody().unmask();
							var imageData = FR.editor.getImageData();
							Ext.get('resolution').update(
								imageData.naturalWidth+
								' <i class="fa fa-times"></i> '+
								imageData.naturalHeight
							);
							FR.editor.zoom(-0.1);
							FR.UI.tbar.doLayout(true);
						},
						crop: function(e) {
							if (!e.detail.width) {return true;}
							Ext.get('resolution').update(
								Math.round(e.detail.width)+
								' <i class="fa fa-times"></i> '+
								Math.round(e.detail.height)
							);
						},
						zoom: function(e) {
							Ext.get('zoomStatus').update(Math.round(e.detail.ratio*100)+'%');
						}
					});
				}, scope: this
			}
		});
	},
	applyChanges: function() {
		this.editor.replace(this.editor.getCroppedCanvas().toDataURL());
		Ext.getCmp('scaleSlider').setValue(1);
		Ext.getCmp('cropToggle').toggle(0, true);
		Ext.getCmp('apply').hide();
		Ext.getCmp('cancel').hide();
		this.UI.tbar.doLayout(true);
	},
	cancelChanges: function() {
		Ext.getCmp('cropToggle').toggle(0);
		Ext.getCmp('scaleSlider').setValue(1);
		Ext.getCmp('apply').hide();
		Ext.getCmp('cancel').hide();
		this.UI.tbar.doLayout(true);
	},
	tryToCloseWindow: function() {
		if (!FR.changesSaved) {
			new Ext.ux.prompt({
				text: 'Discard the changes made?',
				confirmHandler: function() {
					this.closeWindow();
				}, scope: this
			});
			return false;
		}
		this.closeWindow();
	},
	closeWindow: function() {
		if (window.parent) {
			if (FR.vars.windowId) {
				return window.parent.FR.UI.popups[FR.vars.windowId].close();
			}
			with (window.parent) {
				if (FR.UI.FileViewer && FR.UI.FileViewer.isVisible()) {
					return FR.UI.FileViewer.hide();
				}
			}
		}
		window.close();
	},
	save: function(close) {
		this.closeAfterSave = close;
		var canvas = this.editor.getCroppedCanvas();
		canvas.toBlob(function(blob) {
			FlowUtils.simpleUpload({
				urlRoot: FR.vars.URLRoot,
				target: '/?module=fileman&section=do&page=up',
				debug: FR.vars.devMode,
				csrf: FR.vars.csrf_token,
				flowOpts: {
					chunkSize: FR.vars.UploadChunkSize
				},
				query: {
					path: FR.vars.folderPath
				},
				files: [FileRunFile.fromBlob(blob, {name: FR.vars.saveFileName})],
				onProgress: (msg, flow) => {
					FR.status.update(msg);
				},
				onFailure: (msg) => {
					new Ext.ux.prompt({text: msg});
				},
				onSuccess: (msg) => {
					FR.changesSaved = true;
					if (FR.vars.windowId) {
						FR.status.update('');
						window.parent.FR.UI.feedback(msg, 'success');
					} else {
						FR.status.update(msg);
					}
					FR.UI.tbar.doLayout(true);
					if (FR.closeAfterSave) {
						FR.closeWindow();
					}
				}
			});
		}, FR.vars.saveMimeType);
	},
	imageControl: function(title, method) {
		FR.bWin = new Ext.Window({
			title: title,
			width: 450,
			height: 350,
			modal: true,
			layout: 'fit',
			closable: false,
			items: [{
				bodyStyle: 'position: relative;'
			}],
			camanMethod: method,
			tbar: {
				style: 'padding-bottom:15px',
				buttonAlign: 'right',
				items: [{
					cls: 'fr-btn-primary',
					text: 'Apply',
					handler: function() {
						FR.editor.replace(FR.bWin.canvas.dom.toDataURL('image/jpeg'));
						FR.bWin.close();
					}
				},
				{
					text: 'Cancel',
					style: 'margin-left:10px',
					handler: function() {FR.bWin.close();}
				}]
			},
			bbar: {
				buttonAlign: 'center',
				style: 'padding-top:15px',
				items: [
					{
						xtype: 'slider',
						width: 400,
						value: 0,
						minValue: -50,
						maxValue: 50,
						listeners: {
							changecomplete: function (s, newValue) {
								FR.bWin.cam.revert(false);
								FR.bWin.cam[FR.bWin.camanMethod](newValue);
								FR.bWin.cam.render();
							}, scope: this
						}
					}
				]
			},
			listeners: {
				'show': function() {
					this.canvas = this.items.first().body.insertFirst(FR.editor.getCroppedCanvas());
					this.canvas.dom.id = 'mybcanvas';
					this.canvas.dom.setAttribute('data-caman-hidpi-disabled', '1');
					this.canvas.setStyle({
						display: 'block',
						position: 'absolute',
						top: '50%',
						left: '50%',
						transform: 'translate(-50%, -50%)'
					});
					var image = FR.editor.image;

					var boxWidth = this.items.first().body.getWidth();
					var boxHeight= this.items.first().body.getHeight();

					if (image.width > image.height) {
						if (image.width > boxWidth) {
							this.canvas.setWidth(boxWidth);
						} else {
							this.canvas.setHeight(boxHeight);
						}
					} else {
						if (image.height > boxHeight) {
							this.canvas.setHeight(boxHeight);
						} else {
							this.canvas.setWidth(boxWidth);
						}
					}
					FR.bWin.cam = Caman(this.canvas.dom);
				}
			}
		});
		FR.bWin.show();
	}
};
Ext.onReady(() => FR.init());