<?php
use FileRun\Files\Plugin;
use FileRun\Lang;

class custom_handle_url extends Plugin {

	public bool $weblinksCompatible = true;
	static $localeSection = 'Custom Actions: Link Opener';

	function init() {
		$this->JSconfig = [
			'title' => self::t('Link Opener'),
			'iconCls' => 'fa-share-square-o',
			'extensions' => ['url', 'webloc'],
			'newTab' => true,
			'requiredUserPerms' => ['preview'],
			'requires' => ['preview'],
			'replaceDoubleClickAction' => true
		];
	}
	function run() {
		$this->data['contents'] = $this->readFile();
		$ext = \FM::getExtension($this->data['fileName']);
		$url = false;
		if ($ext == 'webloc') {
			$xml = simplexml_load_string($this->data['contents']);
			$array = json_decode(json_encode($xml),TRUE);
			$url = $array['dict']['string'] ?? false;
		} else {
			$c = explode("\n", $this->data['contents']);
			foreach ($c as $r) {
				if (stripos($r, 'URL=') !== false) {
					$url = str_ireplace(['URL=', '\''], [''], $r);
					break;
				}
			}
		}
		if ($url) {
			header('Location: '.$url);
			echo Lang::t('Click <a href="%1" target="_blank">here</a> to open the link', self::$localeSection, [$url]);
			echo '<script>document.location.href = \''.\S::safeJS($url).'\';</script>';
			exit();
		}

		Lang::d('No URL found. Here are the file contents:');
		echo '<br>';
		echo nl2br(\S::safeForHtml($this->data['contents']));
	}
}
