<?php
namespace FileRun;

global $config, $settings;
if (!$config) {exit();}

if ($this->isLimitedPreview()) {
	$this->centeredThumb();
	return;
}

$url = $this->actionURL.'&method=openInBrowser';


$page = [
	'styles' => [
		'basic',
		'normalize',
		$this->url.'/css/main.css?v='.$settings->currentVersion,
		$this->url.'/css/popup.css?v='.$settings->currentVersion
	],
	'scripts' => [
		'jquery',
		$this->url.'/js/app.js?v='.$settings->currentVersion,
		$this->url.'/js/libs/zip.min.js?v='.$settings->currentVersion,
		$this->url.'/js/libs/screenfull.min.js?v='.$settings->currentVersion,
		$this->url.'/js/epub.min.js?v='.$settings->currentVersion,
		$this->url.'/js/reader.min.js?v='.$settings->currentVersion,
	],
	'jsGlobals' => [
		'FR.fileURL' => $url,
		'FR.bookKey' => 'EPUB-'.md5($this->data['fullPath']),
		'FR.themeURL' => UI\CSS::getAssetURL('basic=1')
	],
	'manualEnd' => true
];

require $config['path']['includes'].'/ui/page/plugin.php';
?>

<body>
<div id="sidebar">
	<div id="panels">
          <a id="show-Toc" class="show_view icon-list-1 active" data-view="Toc"><?php echo self::t('TOC');?></a>
          <a id="show-Bookmarks" class="show_view icon-bookmark" data-view="Bookmarks"><?php echo self::t('Bookmarks');?></a>
        </div>
	<div id="tocView" class="view">
	</div>
	<div id="bookmarksView" class="view">
      <ul id="bookmarks"></ul>
    </div>
</div>
<div id="main">
	<div id="titlebar">
		<div id="opener">
			<a id="slider" title="<?php echo self::t('Menu');?>" class="icon-menu"><?php echo self::t('Menu');?></a>
		</div>
		<div id="metainfo">
			<span id="book-title"></span>
			<span id="title-seperator">&nbsp;&nbsp;–&nbsp;&nbsp;</span>
			<span id="chapter-title"></span>
		</div>
		<div id="title-controls">
			<a id="bookmark" class="icon-bookmark-empty"><?php echo self::t('Bookmark');?></a>
			<a id="fullscreen" title="<?php echo self::t('Fullscreen');?>" class="icon-resize-full"><?php echo self::t('Fullscreen');?></a>
		</div>
	</div>
	<div id="divider"></div>
	<div id="prev" class="arrow">‹</div>
	<div id="viewer"></div>
	<div id="next" class="arrow">›</div>
	<div id="loader"><img src="<?php echo $config['url']['root'];?>/images/loading.svg" width="50" height="50"></div>
</div>
<div class="overlay"></div>
</body>
</html>