<?php
namespace FileRun;

global $settings, $config;
if (!$config) {exit();}

$isEditable = false;
if (Perms::check('upload')) {
	if (!$this->data['shareInfo'] || ($this->data['shareInfo'] && $this->data['shareInfo']['perms_upload'])) {
		$isEditable = true;
	}
}
if ($this->data['weblink'] && $isEditable) {
	$isEditable = WebLinks::verifyAllowEditing($this->data['weblink']['linkInfo']);
}
$isClosable = isset($_REQUEST['_popup_id']);
$extension = \FM::getExtension($this->data['fileName']);

$vars = json_encode([
	'isEditable' => $isEditable,
	'isClosable' => $isClosable,
	'URLRoot' => $config['url']['root'],
	'actionURL' => $this->actionURL,
	'fileURL' => $this->actionURL.'&method=loadFileData',
	'path' => $this->data['relativePath'],
	'filename' => $this->data['fileName'],
	'windowId' => \S::fromHTML($_REQUEST['_popup_id']),
	'delimiter' => self::getDelimiterByExt($extension)
]);
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<title><?php echo \S::safeHTML(\S::forHTML($this->data['fileName']));?></title>
	<?php UI\CSS::insertLink();?>
	<link rel="stylesheet" href="<?php echo $this->url;?>/jspreadsheet/jsuites.css?v=<?php echo $settings->currentVersion;?>" />
	<link rel="stylesheet" href="<?php echo $this->url;?>/jspreadsheet/jspreadsheet.css?v=<?php echo $settings->currentVersion;?>" />
	<link rel="stylesheet" href="<?php echo $this->url;?>/jspreadsheet/jexcel.theme.css?v=<?php echo $settings->currentVersion;?>" />

	<?php UI\JS::insertScripts(['ext']);?>
	<script src="<?php echo $this->url;?>/app.js?v=<?php echo $settings->currentVersion;?>"></script>
	<script src="<?php echo $config['url']['root'];?>/?module=fileman&section=utils&page=translation.js&sec=<?php echo \S::forURL("Custom Actions: CSV Editor")?>&lang=<?php echo \S::forURL(Lang::getCurrent())?>"></script>
	<script src="<?php echo $this->url;?>/jspreadsheet/index.min.js?v=<?php echo $settings->currentVersion;?>"></script>
	<script src="<?php echo $this->url;?>/jspreadsheet/jsuites.min.js?v=<?php echo $settings->currentVersion;?>"></script>
	<script>
		FR.settings = <?php echo $vars;?>;
	</script>
</head>

<body id="theBODY" onload="FR.init()">


</body>
</html>