<?php
namespace FileRun;
use \CloudConvert\Transport\HttpTransport;

global $settings, $config;
if (!$config) {exit();}

$ext = \FM::getExtension($this->data['fullPath']);
$ccHttp = new HttpTransport([]);
try {
	$response = $ccHttp->get($ccHttp->getBaseUri() .'/convert/formats', ['filter[input_format]' => $ext]);
	$rs = json_decode($response->getBody(), true);
} catch(\Exception $e) {
	self::outputError($e->getMessage());
}


$page = [
	'styles' => [
		'basic',
		'ext',
		$this->url.'/style.css?v='.$settings->currentVersion
	],
	'scripts' => [
		'ext',
		'https://www.bing.com/api/maps/mapcontrol?callback=GetMap',
		$this->url.'/app.js?v='.$settings->currentVersion
	],
	'jsGlobals' => [
		'var path' => $this->data['relativePath'],
		'var windowId' => \S::fromHTML($_REQUEST['_popup_id']),
		'var csrf' => self::getCSRFToken()
	],
	'manualEnd' => true,
];
require $config['path']['includes'].'/ui/page/plugin.php';
?>


<div id="selectFormat">
	<div style="clear:both;margin:10px;">
		<?php
		if (count($rs['data']) > 0){
			echo self::t('Convert "%1" to:', [\S::safeHTML($this->data['fileName'])]);
		} else {
			echo self::t('No conversion option found for the "%1" file type.', [strtoupper(\S::safeHTML($ext))]);
		}
		?>
	</div>
	<div style="max-width:600px;">
		<div class="x-clear"></div>
	<?php
	foreach ($rs['data'] as $format) {
		?>
		<div class="format extLabel ext_<?php echo \S::safeHTML(strtolower($format['output_format']));?>" data-format="<?php echo \S::safeHTML($format['output_format']);?>"><?php echo \S::safeHTML(strtoupper($format['output_format']));?></div>
	<?php
	}
	?>
		<div class="x-clear" style="height:30px;"></div>
	</div>
</div>
</body>
</html>