<?php
namespace FileRun;

global $settings, $config;
if (!$config) {exit();}

if ($this->data['weblink']) {
	$url = $this->data['weblink']['download_url'];
} else {
	$url = WebLinks::getOneTimeDownloadLink($this->data['fullPath'], $this->data['shareInfo']['id']);
	if (!$url) {exit("Failed to setup weblink");}
}

$page = [
	'styles' => ['basic'],
	'scripts' => [
		'https://www.bing.com/api/maps/mapcontrol?callback=GetMap',
		$this->url.'/app.js?v='.$settings->currentVersion,
	],
	'jsGlobals' => [
		'APIKey' => self::getSetting('APIKey'),
		'fileURL' => $url
	],
	'noJSTrans' => true,
	'contents' => '<div id="myMap" style="position:absolute;width: 100%; height: 100%;"></div>'
];
require $config['path']['includes'].'/ui/page/plugin.php';

$this->logAction();