<?php

class custom_bing_kml_viewer extends \FileRun\Files\Plugin {

	public bool $weblinksCompatible = true;
	public $online = true;
	static $localeSection = 'Custom Actions: Bing Maps';

	function init() {
		$this->settings = [
			[
				'key' => 'APIKey',
				'title' => self::t('Bing Maps API Key'),
				'width' => '100%',
				'large' => true,
				'comment' => '<a href="https://msdn.microsoft.com/en-us/library/ff428642.aspx" target="_blank">Getting a Bing Maps Key</a>'
			]
		];
		$this->JSconfig = [
			"title" => self::t("Bing Maps"),
			'icon' => 'images/icons/bing.svg',
			"extensions" => ["xml", "kmz", "gpx"],
			"popup" => true,
			"requiredUserPerms" => ["download"],
			"requires" => ["download"]
		];
	}

	function isDisabled() {
		return (strlen(self::getSetting('APIKey')) == 0);
	}

	function run() {
		require $this->path."/display.php";
	}
}