window.addEventListener('load', function () {
  var loadMsg = document.getElementById('loadMsg');
  if (typeof Microsoft != 'undefined') {
    loadMsg.remove();
  } else {
    loadMsg.firstChild.innerText = 'Failed to load API';
  }
});
function GetMap() {
	map = new Microsoft.Maps.Map('#myMap', { credentials: APIKey});
	//Load the GeoXml module.
	Microsoft.Maps.loadModule('Microsoft.Maps.GeoXml', function () {
		//Parse the XML data.
		Microsoft.Maps.GeoXml.readFromUrl(fileURL, null, function (data) {
			//Do something with the parsed XML data, in this case render it.
			renderGeoXmlDataSet(data);
		});
	});
}
function renderGeoXmlDataSet(data) {
	//Add all shapes that are not in layers to the map.
	if (data.shapes) {
		map.entities.push(data.shapes);
	}

	//Add all data layers to the map.
	if (data.layers) {
		for (var i = 0, len = data.layers.length; i < len; i++) {
			map.layers.insert(data.layers[i]);
		}
	}

	//Add all screen overlays to the map.
	if (data.screenOverlays) {
		for (var i = 0, len = data.screenOverlays.length; i < len; i++) {
			map.layers.insert(data.screenOverlays[i]);
		}
	}

	if (data.summary && data.summary.bounds) {
		//Set the map view to focus show the data.
		map.setView({ bounds: data.summary.bounds, padding: 30 });
	}
}