<?php
global $config, $settings;
if (!$config) {exit();}

if ($this->isLimitedPreview() && !$this->getSetting('allow_without_download')) {
	$this->centeredThumb();
	return;
}

$context = \S::fromHTML($_REQUEST['context']);

$fileData = [];
if ($context != 'embedded') {
	$fileData = [
		'filetype' => 'mp3',
		'path' => $this->data['relativePath'],
		'filename' => $this->data['fileName'],
		'ext' => \FM::getExtension($this->data['fileName'])
	];
	if ($this->data['weblink']) {
		$fileData['url'] = $this->data['weblink']['base_url'].'&method=stream';
	}
}

$page = [
	'loadMsg' => 'Loading audio player...',
	'styles' => ['basic', 'ext', 'fa'],
	'scripts' => [
		'ext',
		'ext/components/slider',
		$this->url.'/js/app.js?v='.$settings->currentVersion,
		$this->url.'/js/howler.min.js?v='.$settings->currentVersion,
		$this->url.'/js/aurora.js?v='.$settings->currentVersion,
		$this->url.'/js/alac.js?v='.$settings->currentVersion,
		$this->url.'/js/aac.js?v='.$settings->currentVersion
	],
	'jsGlobals' => [
		'fileItem' => $fileData,
		'Settings' => [
			'disable_autoplay' => (bool) $this->getSetting('disable_autoplay'),
			'context' => $context
		]
	]
];
require $config['path']['includes'].'/ui/page/plugin.php';

