<?php

use FileRun\Files\Plugin;

class custom_audio_player extends Plugin {

	public bool $weblinksCompatible = true;
	static $localeSection = "Custom Actions: Audio Player";
	static $publicMethods = ['stream', 'thumb'];

	function init() {
		$this->JSconfig = [
			"title" => self::t("Audio Player"),
			'iconCls' => 'fa-music',
			'useWith' => ['mp3'],
			"popup" => true,
			"requires" => ["download"]
		];
		$this->settings = [
			[
				'key' => 'disable_autoplay',
				'title' => self::t('Disable the automatic playback of the next file'),
				'type' => 'checkbox'
			],
			[
				'key' => 'allow_without_download',
				'title' => self::t('Allow playback without download permission'),
				'type' => 'checkbox',
				'helpText' => self::t('Use this option only if your files are not confidential.')
			]
		];
	}
	function run() {
		require $this->path . "/display.php";
	}

	function stream() {
		/*ffmpeg -i input.wav -acodec libmp3lame -b:a 128k output.mp3*/
		$this->streamFileForPreview();
	}
}