function FlowFile(flowObj,file,query){this.flowObj=flowObj;this.file=file;this.query=query;this.size=file.size;this.name=file.fileName||file.name;var iOS=/(iPad|iPhone|iPod)/g.test(navigator.userAgent);if(iOS&&this.name.substring(0,5)=="image"){this.name="image_"+this.size+this.name.substring(5)}this.relativePath=file.relativePath||file.webkitRelativePath||false;if(this.relativePath&&this.relativePath!=this.name){baseNameStartPos=this.relativePath.length-this.name.length;var baseName=this.relativePath.substring(baseNameStartPos);if(baseName==this.name){this.relativePath=this.relativePath.substring(0,baseNameStartPos)}}this.uniqueIdentifier=flowObj.generateUniqueIdentifier(file);this.offset=0;this.chunks=[];this.uploadingChunk=false;this.completedChunks=0;this.completedBytes=0;this.lastCompletedBytes=0;this.complete=false;this.uploading=false;this.paused=false;this.progress=0;this.queuePaused=false;this.error=false;this.averageSpeed=0;this.currentSpeed=0;this._lastProgressCallback=Date.now();this._prevTransferredSize=0}FlowFile.prototype={measureSpeed:function(){var timeSpan=Date.now()-this._lastProgressCallback;if(!timeSpan){return}var smoothingFactor=this.flowObj.opts.speedSmoothingFactor;this.currentSpeed=Math.max((this.completedBytes-this._prevTransferredSize)/timeSpan*1e3,0);this.averageSpeed=smoothingFactor*this.currentSpeed+(1-smoothingFactor)*this.averageSpeed;this.flowObj.averageSpeed=this.averageSpeed;this._prevTransferredSize=this.completedBytes},chunkEvent:function(event,serverReply){switch(event){case"progress":if(Date.now()-this._lastProgressCallback<this.flowObj.opts.progressCallbacksInterval){break}this.reportProgress();break;case"error":this.error=true;this.paused=true;this.flowObj.paused=true;this.flowObj.completedBytes-=this.completedBytes;this.completedBytes=0;this.reset();this.flowObj.onFileError(this,serverReply);break;case"success":this.error=false;this.paused=false;this.removeUploadingChunk(this.uploadingChunk);if(this.completedChunks==this.chunks.length){this.reportProgress();this.uploading=false;this.complete=true;this.currentSpeed=0;this.averageSpeed=0;this.flowObj.onFileSuccess(this,serverReply);this.file=null}else{this.uploadNextChunk()}break;case"retry":this.flowObj.fire("fileRetry",this);break}},reportProgress:function(){this.measureProgress();this.measureSpeed();this.flowObj.fire("fileProgress",this);this.flowObj.fire("progress",this.flowObj);this._lastProgressCallback=Date.now()},uploadNextChunk:function(){if(!this.paused){this.flowObj.each(this.chunks,function(chunk){if(chunk&&chunk.status()==="pending"){chunk.send();return false}})}},getOffsetHandler:function(event){this.offset=0;var status=this.xhr.status;var message=this.xhr.responseText;this.xhr=null;var proceed=this.flowObj.opts.validateGetOffsetResponse.call(this.flowObj.opts.validateGetOffsetResponseScope||this,this,status,message);if(proceed){this.lastCompletedBytes=this.completedBytes;this.completedBytes=this.offset;if(this.lastCompletedBytes>0){this.flowObj.completedBytes-=this.lastCompletedBytes}this.flowObj.completedBytes+=this.offset;this.prepareChunks();this.uploadNextChunk()}else{this.error=true;this.uploading=false;this.flowObj.onFileError(this,message)}},getOffset:function(){this.xhr=new XMLHttpRequest;this.xhr.addEventListener("load",this.getOffsetHandler.bind(this),false);this.xhr.addEventListener("error",this.getOffsetHandler.bind(this),false);var query=this.query;if(typeof query==="function"){query=query(this)}var additionalData={flowGetOffset:1,flowTotalSize:this.size,flowFilename:this.name};if(this.relativePath){additionalData.flowRelativePath=this.relativePath}query=this.flowObj.extend(additionalData,query);var target=this.flowObj.opts.target;var data=new FormData;this.flowObj.each(query,function(v,k){data.append(k,v)});this.xhr.open("POST",target);this.xhr.withCredentials=this.flowObj.opts.withCredentials;this.flowObj.each(this.flowObj.opts.headers,function(v,k){this.xhr.setRequestHeader(k,v)},this);this.xhr.send(data)},reset:function(){this.paused=false;this.queuePaused=false;this.uploading=false;this.currentSpeed=0;this.averageSpeed=0;this.offset=0;this.uploadingChunk=false;this.completedChunks=0;this.chunks=[]},pause:function(pauseInTheQueue){if(this.complete){return false}var fileWasUploading;if(this.uploading){if(this.uploadingChunk){this.uploadingChunk.abort()}fileWasUploading=true}this.reset();if(pauseInTheQueue){this.queuePaused=true}this.paused=true;this.flowObj.onFilePause(this,pauseInTheQueue,fileWasUploading)},start:function(){if(this.complete){return false}this.reset();this.uploading=true;this.flowObj.onFileStart();if(!this.flowObj.opts.chunkSize||this.size<this.flowObj.opts.chunkSize&&this.size<this.flowObj.opts.resumeLargerThan){this.prepareChunks();this.uploadNextChunk()}else{this.getOffset()}},prepareChunks:function(){if(this.flowObj.opts.chunkSize>0){var chunkCount=Math.max(Math.ceil((this.file.size-this.offset)/this.flowObj.opts.chunkSize),1)}else{var chunkCount=1}for(var offset=0;offset<chunkCount;offset++){this.chunks.push(new FlowChunk(this.flowObj,this,offset))}},removeUploadingChunk:function(){var chunkCount=this.chunks.length;for(var i=0;i<chunkCount;i++){if(this.chunks[i]==this.uploadingChunk){this.uploadingChunk=null;this.chunks[i]=null;return true}}return false},measureProgress:function(){if(this.error){this.progress=0}else{if(this.complete){this.progress=1}else{if(this.size==0&&this.completedBytes==0){this.progress=1}else{this.progress=this.completedBytes/this.size}}}},timeRemaining:function(){if(this.paused||this.error||this.complete){return 0}var delta=this.size-this.completedBytes;if(delta&&!this.averageSpeed){return Number.POSITIVE_INFINITY}if(!delta&&!this.averageSpeed){return 0}return Math.floor(delta/this.averageSpeed)}};