function Flow(opts){this.files=[];this.lastCompletedFile=false;this.paused=false;this.averageSpeed=0;this.completedFiles=0;this.uploadingFiles=0;this.size=0;this.completedBytes=0;this.defaults={chunkSize:false,singleFile:false,fileParameterName:"file",progressCallbacksInterval:500,speedSmoothingFactor:.1,headers:{},withCredentials:false,target:"/",generateUniqueIdentifier:null,maxChunkRetries:0,resumeLargerThan:0,chunkRetryInterval:null,maxSimultaneous:1,validateChunkResponse:function(status,message){if(status!="200"){return"retry"}try{var rs=JSON.parse(message)}catch(er){return"retry"}if(rs){if(rs.success){return"success"}else{return"error"}}},validateGetOffsetResponse:function(file,status,message){if(status==200){try{var rs=JSON.parse(message)}catch(er){return false}if(rs&&rs.success){if(rs.offset){rs.offset=parseInt(rs.offset);if(!isNaN(rs.offset)&&isFinite(rs.offset)){file.offset=rs.offset}}return true}}}};this.opts={};this.events={};var $=this;this.onDrop=function(event,query){event.stopPropagation();event.preventDefault();var dataTransfer=event.dataTransfer||event.clipboardData;if(dataTransfer.items&&dataTransfer.items[0]&&dataTransfer.items[0].webkitGetAsEntry){$.webkitReadDataTransfer(event,query)}else{$.addFiles(dataTransfer.files,event,query)}};this.opts=this.extend({},this.defaults,opts||{})}Flow.prototype={on:function(event,callback){event=event.toLowerCase();if(!this.events.hasOwnProperty(event)){this.events[event]=[]}this.events[event].push(callback)},off:function(event,fn){if(event!==undefined){event=event.toLowerCase();if(fn!==undefined){if(this.events.hasOwnProperty(event)){arrayRemove(this.events[event],fn)}}else{delete this.events[event]}}else{this.events={}}},fire:function(event,args){args=Array.prototype.slice.call(arguments);event=event.toLowerCase();var preventDefault=false;if(this.events.hasOwnProperty(event)){this.each(this.events[event],function(callback){preventDefault=callback.apply(this,args.slice(1))===false||preventDefault})}if(event!="catchall"){args.unshift("catchAll");preventDefault=this.fire.apply(this,args)===false||preventDefault}return!preventDefault},webkitReadDataTransfer:function(event,query){var $=this;var items=event.dataTransfer?event.dataTransfer.items:event.clipboardData.items;var queue=items.length;var files=[];this.each(items,function(item){var entry=item.webkitGetAsEntry();if(!entry){decrement();return}if(entry.isFile){fileReadSuccess(item.getAsFile(),entry.fullPath)}else{readDirectory(entry.createReader(),entry)}});function readDirectory(reader,entry){reader.readEntries(function(entries){if(entries.length){queue+=entries.length;$.each(entries,function(subentry){var fullPath=subentry.fullPath;if(subentry.isFile){subentry.file(function(file){fileReadSuccess(file,fullPath)},readError)}else if(subentry.isDirectory){readDirectory(subentry.createReader(),subentry)}});readDirectory(reader,entry)}else{decrement()}},readError)}function fileReadSuccess(file,fullPath){file.relativePath=fullPath;files.push(file);decrement()}function readError(fileError){throw fileError}function decrement(){if(--queue==0){$.addFiles(files,event,query)}}},generateUniqueIdentifier:function(file){var custom=this.opts.generateUniqueIdentifier;if(typeof custom==="function"){return custom(file)}var relativePath=file.relativePath||file.webkitRelativePath||file.fileName||file.name;return file.size+"-"+relativePath.replace(/[^0-9a-zA-Z_-]/gim,"")},browseFiles:function(opts){if(!opts){opts={entireFolder:false,singleFile:true}}FlowUtils.browseFiles({entireFolder:opts.entireFolder,singleFile:opts.singleFile,onSelect:function(files,e){if(files.length>0){this.addFiles(files,e,opts.query)}},scope:this})},start:function(){this.paused=false;this.uploadNextFile();this.fire("uploadStart")},uploadNextFile:function(){if(this.paused){return false}var queuePausedFiles=0;var uploadingFiles=0;var nothingToDo=true;this.each(this.files,function(file){if(!file.complete){if(file.queuePaused){queuePausedFiles++}else{if(!file.uploading){if(this.uploadingFiles<this.opts.maxSimultaneous){nothingToDo=false;file.start()}else{return false}}else{uploadingFiles++}}}},this);if(nothingToDo&&!queuePausedFiles&&!uploadingFiles){this.fire("complete")}},pause:function(){this.paused=true;this.each(this.files,function(file){if(!file.queuePaused&&!file.paused&&!file.complete){file.pause()}});this.uploadingFiles=0},removeAll:function(){for(var i=this.files.length-1;i>=0;i--){this.removeFile(this.files[i])}this.averageSpeed=0;this.uploadingFiles=0;this.lastCompletedFile=false},getProgress:function(){if(this.size==0&&this.completedBytes==0){return 1}return this.completedBytes/this.size},onFileSuccess:function(file,serverReply){this.uploadingFiles--;this.completedFiles++;this.lastCompletedFile=file;this.fire("progress",this);this.fire("fileSuccess",file,serverReply);this.uploadNextFile()},onFileError:function(file,serverReply){this.uploadingFiles--;this.fire("fileError",file,serverReply);this.fire("error",serverReply,file)},onFilePause:function(file,pauseInTheQueue,fileWasUploading){if(fileWasUploading){this.uploadingFiles--}if(pauseInTheQueue){this.uploadNextFile()}this.fire("fileProgress",file)},onFileStart:function(){this.uploadingFiles++},addFile:function(file,event,query){this.addFiles([file],event,query)},addFiles:function(fileList,event,query){this.each(fileList,function(file){if(this.opts.singleFile&&this.files.length>0){return false}if(!(file.size%4096===0&&(file.name==="."||file.fileName==="."))&&!this.getFromUniqueIdentifier(this.generateUniqueIdentifier(file))){var f=new FlowFile(this,file,query);if(this.fire("fileAdded",f,event)){this.files.push(f);this.size+=f.size}}},this);this.fire("filesSubmitted",this.files,event);if(this.opts.startOnSubmit){this.start()}},removeFile:function(file){var removedUploading=false;for(var i=this.files.length-1;i>=0;i--){if(this.files[i]===file){this.size-=file.size;if(file.uploading){if(file.uploadingChunk){file.uploadingChunk.abort()}removedUploading=true;this.uploadingFiles--}if(file.complete){this.completedFiles--}this.completedBytes-=file.completedBytes;file=null;this.files.splice(i,1)}}if(removedUploading){this.uploadNextFile()}return true},getFromUniqueIdentifier:function(uniqueIdentifier){var ret=false;this.each(this.files,function(file){if(file.uniqueIdentifier===uniqueIdentifier){ret=file}});return ret},timeRemaining:function(){var sizeDelta=this.size-this.completedBytes;if(sizeDelta&&!this.averageSpeed){return Number.POSITIVE_INFINITY}if(!sizeDelta&&!this.averageSpeed){return 0}return Math.floor(sizeDelta/this.averageSpeed)},arrayRemove:function(array,value){var index=array.indexOf(value);if(index>-1){array.splice(index,1)}},extend:function(dst,src){this.each(arguments,function(obj){if(obj!==dst){this.each(obj,function(value,key){dst[key]=value})}},this);return dst},each:function(obj,callback,context){if(!obj){return}if(typeof obj.length!=="undefined"){for(var key=0;key<obj.length;key++){if(callback.call(context,obj[key],key)===false){return}}}else{for(var key in obj){if(obj.hasOwnProperty(key)&&callback.call(context,obj[key],key)===false){return}}}}};var FlowUtils={browserSupport:{files:typeof window.File!=="undefined"&&typeof Blob!=="undefined"&&typeof window.FileList!=="undefined"&&(typeof Blob.prototype.slice!=="undefined"||typeof Blob.prototype.webkitSlice!=="undefined"||typeof Blob.prototype.mozSlice!=="undefined"),folders:true},browseFiles:function(opts){var input=document.createElement("input");input.setAttribute("type","file");if(!opts.singleFile){input.setAttribute("multiple","multiple");if(opts.entireFolder){input.setAttribute("webkitdirectory","webkitdirectory");input.setAttribute("directory","directory")}}input.style.display="none";input.addEventListener("change",function(e){opts.onSelect.call(opts.scope,e.target.files,e);document.body.removeChild(this)},false);document.body.appendChild(input);input.click()}};FlowUtils.DropZone=function(opts){if(!FlowUtils.browserSupport.files){return}this.opts=opts;opts.domNode.addEventListener("dragenter",function(e){e.preventDefault();var target=this.opts.findTarget.call(this.opts.scope,e,this);if(target){this.manager.addHighLight(target,this.opts.overClass)}}.bind(this),false);opts.domNode.addEventListener("dragover",function(e){e.dataTransfer.dropEffect="copy";e.stopPropagation();e.preventDefault()}.bind(this),false);opts.domNode.addEventListener("drop",function(e){e.stopPropagation();e.preventDefault();this.manager.removeHighlight();if(e.dataTransfer.files.length==0){if(FR.UI.feedback){FR.UI.feedback(FR.T("To upload files, drag them from your computer"))}return false}var target=this.opts.findTarget.call(this.opts.scope,e,this);if(target){this.opts.onDrop.call(this.opts.scope,e,target)}}.bind(this),false)};FlowUtils.DropZoneManager={zones:[],lastTarget:false,add:function(opts){if(!FlowUtils.browserSupport.files){return}var dz=new FlowUtils.DropZone(opts);dz.manager=this;this.zones.push(dz)},addHighLight:function(t,cls){var lt=this.lastTarget;if(lt){lt.el.classList.remove(lt.cls)}t.el.classList.add(cls);this.lastTarget={el:t.el,cls:cls};window.setTimeout(function(){FlowUtils.DropZoneManager.removeHighlight()},3e3)},removeHighlight:function(){if(this.lastTarget){this.lastTarget.el.classList.remove(this.lastTarget.cls)}}};